<?php
require_once('assets/init.php');

header('Content-Type: application/json');

if (empty($_GET['user_id'])) {
    echo json_encode(['error' => 'No user_id provided']);
    exit();
}

$user_id = Wo_Secure($_GET['user_id']);
$user_data = Wo_UserData($user_id);

if ($user_data) {
    // Return only the necessary fields
    $response = [
        'user_data' => [
            'user_id' => $user_data['user_id'],
            'username' => $user_data['username'],
            'email' => $user_data['email'],
            'first_name' => $user_data['first_name'],
            'last_name' => $user_data['last_name'],
            'avatar' => $user_data['avatar'],
            'gender' => $user_data['gender'] ?? '',
            'verified' => $user_data['verified'] ?? '0',
        ]
    ];
    echo json_encode($response);
} else {
    echo json_encode(['error' => 'User not found']);
}
?>
