/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.CircularDependencyException;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

class ModuleDescriptorSorter {
    private final Collection moduleDescriptors;
    private final Iterator moduleDescriptorsIterator;
    private final List sorted = new LinkedList();

    public static List sortNodes(Collection nodes) {
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> dependenciesMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> nulls = new ArrayList<IvyNode>();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (node.getDescriptor() == null) {
                nulls.add(node);
                continue;
            }
            ArrayList<IvyNode> n = (ArrayList<IvyNode>)dependenciesMap.get(node.getDescriptor());
            if (n == null) {
                n = new ArrayList<IvyNode>();
                dependenciesMap.put(node.getDescriptor(), n);
            }
            n.add(node);
        }
        List list = ModuleDescriptorSorter.sortModuleDescriptors(dependenciesMap.keySet());
        ArrayList<IvyNode> ret = new ArrayList<IvyNode>((int)((double)list.size() * 1.3 + (double)nulls.size()));
        for (int i = 0; i < list.size(); ++i) {
            ModuleDescriptor md = (ModuleDescriptor)list.get(i);
            List n = (List)dependenciesMap.get(md);
            ret.addAll(n);
        }
        ret.addAll(0, nulls);
        return ret;
    }

    public static List sortModuleDescriptors(Collection moduleDescriptors) throws CircularDependencyException {
        return new ModuleDescriptorSorter(moduleDescriptors).sortModuleDescriptors();
    }

    public ModuleDescriptorSorter(Collection moduleDescriptors) {
        this.moduleDescriptors = moduleDescriptors;
        this.moduleDescriptorsIterator = new LinkedList(moduleDescriptors).iterator();
    }

    public List sortModuleDescriptors() throws CircularDependencyException {
        while (this.moduleDescriptorsIterator.hasNext()) {
            this.sortModuleDescriptorsHelp((ModuleDescriptor)this.moduleDescriptorsIterator.next(), new Stack());
        }
        return this.sorted;
    }

    private void sortModuleDescriptorsHelp(ModuleDescriptor current, Stack callStack) throws CircularDependencyException {
        if (this.sorted.contains(current)) {
            return;
        }
        if (callStack.contains(current)) {
            callStack.add(current);
            throw new CircularDependencyException(callStack.toArray(new ModuleDescriptor[0]));
        }
        DependencyDescriptor[] descriptors = current.getDependencies();
        ModuleDescriptor moduleDescriptorDependency = null;
        for (int i = 0; descriptors != null && i < descriptors.length; ++i) {
            moduleDescriptorDependency = this.getModuleDescriptorDependency(descriptors[i]);
            if (moduleDescriptorDependency == null) continue;
            callStack.push(current);
            this.sortModuleDescriptorsHelp(moduleDescriptorDependency, callStack);
            callStack.pop();
        }
        this.sorted.add(current);
    }

    private ModuleDescriptor getModuleDescriptorDependency(DependencyDescriptor descriptor) {
        Iterator i = this.moduleDescriptors.iterator();
        ModuleDescriptor md = null;
        while (i.hasNext()) {
            md = (ModuleDescriptor)i.next();
            if (!descriptor.getDependencyId().equals(md.getModuleRevisionId().getModuleId())) continue;
            if (md.getResolvedModuleRevisionId().getRevision() == null) {
                return md;
            }
            if (!descriptor.getDependencyRevisionId().acceptRevision(md.getResolvedModuleRevisionId().getRevision())) continue;
            return md;
        }
        return null;
    }
}

